package org.msh.tb.bd.dashboard.summaryrep.parser;

import org.msh.tb.bd.dashboard.summaryrep.data.SummaryIndicatorData;
import org.msh.utils.date.Period;

import java.util.List;

/**
 * Created by mauri on 23/05/2017.
 * Service that will process the summary result provided by IndicatorQuery and returns it as a SummaryIndicatorData
 */
public interface IndicatorParser {

    /**
     * @param result the summary result from IndicatorQuery
     * @param locationDesc the description of the location (admin unit or country)
     * @return The summarized result as a SummaryIndicatorData instance
     */
    SummaryIndicatorData parse(List<Object[]> result, String locationDesc);

    /**
     *
     * @param result the summary result from IndicatorQuery
     * @param locationDesc the description of the location (admin unit or country)
     * @param nationalResult the national result to be included as comparision
     * @return The summarized result as a SummaryIndicatorData instance
     */
    SummaryIndicatorData parse(List<Object[]> result, String locationDesc, SummaryIndicatorData nationalResult);

    /**
     * @return the period that will be used by IndicatorQuery to filter the result.
     */
    Period getPeriod();

}
